<!DOCTYPE html>
<html>
	<head>	
		<title>4 MILLION YEAR 2001: A SPACE ODYSSEY</title>
		<link rel="shortcut icon" type="image/x-icon" href="favicon.ico">
		<meta name="description" content="4MY2001AS0 is an open-source four million year movie by Emilie Brout & Maxime Marion launched on March 20, 2013, which extends the famous ellipsis of '2001: A Space Odyssey' by Stanley Kubrick to the real time it represents.">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<?php 
			// get if it has to display informations on the project or not via the URL			
			$display_info = false;
			if (isset($_GET['info'])){ $display_info = $_GET['info'] ; }
			//only refresh if info isn't displayed
			if(!$display_info){ echo '<meta http-equiv="refresh" content="1">'; }else{?>   
				<script type="text/javascript">
				var _gaq = _gaq || [];
				_gaq.push(['_setAccount', 'UA-27384393-1']);
				_gaq.push(['_trackPageview']);
				(function() {
				var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
				ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
				var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
				})();
				</script>     		
				<?php } ?>
	</head>
	<body style="margin:0; background-color:#000;">	
		<?php 	
			// get page URL and clear 'info' value to only keep the pure URL of index.php
			$page_URL = 'http';
			if ($_SERVER["HTTPS"] == "on") {$page_URL .= "s";}
			$page_URL .= "://";
			if ($_SERVER["SERVER_PORT"] != "80") {
			 $page_URL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
			} else { $page_URL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"]; }
			$findme   = 'index.php?';
			$pos = strpos($page_URL, $findme);
			if ($pos === false) { // pure URL already
			} else { $page_URL = substr($page_URL,0,($pos-1)); }			
		
			// the date when the movie was started
			$date_start = new DateTime('2013-03-20 00:00:00');
			// the actual date
			$date_now = date('Y-m-d h:i:s');
			$date_now = new DateTime( $date_now );
			// gap in days between the 2 dates
			$diff = $date_start->diff($date_now);
			$dates_gap= $diff->days; 

			$frames_number = 457; // number of frames in the video 
			$video_length = 4000000*365.2422; // length of the video in days			
			$frame_time = $video_length/$frames_number;	// time of a single frame in days
			
			// finding the last frame played and the % of avancement of the next frame, for opacity 
			$frame_A = floor($dates_gap/$frame_time); 
			$frame_B = ($dates_gap-($frame_A*$frame_time))/$frame_time;

			// if the movie isn't done
			if(($frame_A+1) < $frames_number){ 
				// drawing last frame in fullscreen 
				echo '<div style="position:absolute; top:0px; left:0px; width:100%; height:100%; background: url(4MY2001ASO_images/4MY_'.$frame_A.'.jpg) no-repeat center center fixed;
					 -webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover;"></div>';
				// drawing next frame in fullscreen with opacity
				echo '<div style="cursor:none; position:absolute; top:0px; left:0px; width:100%; height:100%; background: url(4MY2001ASO_images/4MY_'.($frame_A+1).'.jpg) no-repeat center center fixed;
					 -webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover; 
					 filter:alpha(opacity='.($frame_B*100).');-moz-opacity:'.$frame_B.';opacity: '.$frame_B.';"></div>';	
			}else{ // The END
				echo '<div style="margin:20px;">THE END ! <br>The Movie is now done. Thank you for paying attention.<br>Emilie Brout & Maxime Marion (CCC) 2013</div>';
			}
		
		if(!$display_info){
		?>	
			<div style="position:absolute; top:70%; left:70%; width:30%; height:30%; cursor:auto; align:left;">
			  <div style="position:absolute; bottom:25px; right:30px; align:left; font-size:16px; font-family:arial;"><a href="<?php echo $page_URL ?>index.php?info=true" style="color:#333; text-decoration:none;">+ info</a></div>
			</div>
		<?php }else{ ?>
			<div style="position:absolute; top:0%; left:63%; width:37%; height:100%; cursor:auto; font-size:14px; font-family:arial;">
				<div style="margin:22px; color:#CCC; background-color:#000;">
				<img style="width:100%;" src="4MY2001ASO_title.jpg">
					<div style="padding:20px; ">
						<h1 style="font-size:16px; margin-bottom:3px;">4 MILLION YEAR 2001: A SPACE ODYSSEY</h1>
						<span style="color:#999;">EBMM (ccc) 2013 - <a href="http://www.eb-mm.net" style="color:#999; text-decoration:none;">www.eb-mm.net</a><br>Version 1.0 - Emilie Brout & Maxime Marion 2013</span>
						<p>4MY2001:ASO was launched on March 20, 2013.</p>
						<p>4MY2001:ASO is a video and a net-art project, which consists of the famous ellipsis of Stanley Kubrick&#39;s film "2001: A Space Odyssey" (1968) slowed down so that a single, continuous viewing lasts for millions of years. This video is only composed of the two scenes that come before and after the ellipsis - the longest in Cinema History - when a bone thrown by an Australopithecus becomes a spaceship, symbolizing four millions years of evolution. This video is played with the PHP language in an extremely slow rythm, fading frames in each other according to the passed time since its launch.</p>
						<p>The artists guarantee the perpetuation of the project as long as they'll live, but because the movie will only end a very long time after their death, the complete source of the project is <a href="4MY2001ASO_source.zip" style="color:#CCC;">available here</a>. <br>So, anybody can download it, unzip it and copy it on their own website, to ensure that the project will continue to be accessible for everyone. The source code is simple, commented and W3C compliant, so it will be easier to adapt it to another language when PHP will disappear.</p>
						<div style="margin-top:60px; text-align:right;"><a href="http://copie-copains-club.net" target="_blank" style="text-decoration:none;"><span style="color:#CCC;">work under </span><img src="http://copie-copains-club.net/logos/CCC_favicon.png"  style="margin-left:2px; margin-right:3px;" > <span style="color:#CCC;">license</span></a></div>
					</div>
				</div>
				<div style="position:absolute; bottom:25px; right:30px; align:left; font-size:16px; "><a href="<?php echo $page_URL ?>" style="color:#333; text-decoration:none;">- info</a></div>
			</div>		
		<?php } ?>
	</body>
</html>


